﻿// url: Is the relative path of the page you want to change part or the entire content.
// flag: Is the flag located on Common.master and it tells if the content replace functionality is active or not.
// states: All the states that will have a different content.
// fileName: First part of the file name used to change the configured part of content.
// dataGroup: grouping the same states that can share the same content, this name will replace the state name at the html filename.
var uaoStates = ['Maryland', 'Georgia', 'Florida', 'North Carolina', 'South Carolina', 'New York', 'Alabama', 'Pennsylvania', 'Virginia', 'West Virginia', 'Ohio', 'Illinois', 'Indiana', 'Kentucky', 'Texas', 'Louisiana', 'Mississippi'];
var pagesWithLocalizableContent = [
    { url: '/Personal', flag: '__swapPersonalFlag', states: uaoStates, fileName: 'personal', dataGroup: 'UAO' },
    { url: '/Personal/Products/Checking', flag: '__swapLocContent', states: uaoStates, fileName: 'infotbl', dataGroup: 'UAO' },
    { url: '/Personal/Products/Savings', flag: '__swapSavingsFlag', states: uaoStates, fileName: 'savings', dataGroup: 'UAO' },
    { url: '/Personal/Products/Deposit-Interest-Rates', flag: '__swapInterestRatesContent', states: ['Maryland', 'Georgia'], fileName: 'eme' }
];
var uaoMaintenance = false;
var currentDataGroup;

function __Expand(x) {
    // grab rel attribute - this will hold the div to expand
    var rel = x.attr("rel");
    var rev = x.attr("rev"); // if provided, used to hide link after expansion; e.g. used in Testimonials
    if (rel) {
        // find matching element and show/hide
        var elem = $("#" + rel);
        if (elem) {

            if (elem.is(":visible")) {
                x.removeClass("down");
            }
            else {
                x.addClass("down");
            }

            _Slide(elem);
        }
        if (rev) {
            //x.hide();
        }
    }
}

// Get weather forecast
function _GetWeather(zc) {
    var city = new String();
    var st = new String();

    $.ajax({
        type: "POST",
        url: "/Lib/WFNB.Functions.GetWeather.ashx?ZipCode=" + zc,
        contentType: "application/json; charset=utf-8",
        data: {},
        dataType: "json",
        success: function (xResultObj, textStatus, xhrObj) {
            if (xResultObj !== null) {
                if (location) {
                    city = xResultObj.City;
                    st = xResultObj.State;
                }

                var composedLocation = "Location not found.";
                if (st !== undefined && st !== null) {
                    composedLocation = st;

                    if (city !== undefined && city !== null) {
                        composedLocation = city + ", " + st;
                    }
                }

                // set objects where we can
                if (__spnrootlocation) { __spnrootlocation.text(composedLocation); }
                if (_spnwlocation) { _spnwlocation.text(composedLocation); }

                // if nested page called for a location-based content swap, make sure this is processed
                // AFTER the ajax call

                pagesWithLocalizableContent.forEach(function (pageItem) {
                    if (
                        (
                            window.location.pathname.endsWith(pageItem.url)
                            ||
                            window.location.pathname.endsWith(pageItem.url + "/")
                        )
                        &&
                        window[pageItem.flag]
                    ) {
                        swapContent(pageItem);
                    }
                })
            }
        },
        error: function (xhrObj, textStatus, errorThrown) {
            // ?
        }
    });
}

function __GoTab(idx) {
    var thisAnch = $("ul.tabs li a[href='" + idx + "']");
    if (thisAnch.length > 0) {

        var anchParent = thisAnch.parent();

        if (anchParent.length > 0) {

            $("ul.tabs li").removeClass("active"); //Remove any "active" class
            anchParent.addClass("active"); //Add "active" class to selected tab
            $(".tab_content").hide(); //Hide all tab content

            $(idx).fadeIn(); //Fade in the active ID content
        }
    }
}

function __InitClicks() {

    __hlChangeLocation.click(function () {
        __LoadZipChange();
    });

    __selQL.change(function () {

        var xSel = $(this).find(":selected");

        if (xSel) {
            var xOut = xSel.attr("title");
            var xVal = xSel.attr("value");

            if (xVal) {

                // clean xVal for localization; C1 quirk
                var hIdx = xVal.indexOf("/Home/");
                if (hIdx > 0) {
                    xVal = xVal.replace("/Home", "").replace(".aspx", "");
                }

                if (xOut) {
                    _SpeedBump(xVal);
                }
                else {
                    document.location.href = xVal;
                }
            }
        }
    });

}

function __InitEvents() {

    /* init search */
    __txtSearchTerms.keyup(function (e) {
        if (e.keyCode === 13) {
            __btnSearchTerms.click();
            return false;
        }
    });

    /* init all expando classes */
    $(".exp").click(function () {
        __Expand($(this));
    });

}

function __LoadZipChange() {
    // note that we DON'T have have to traverse FB dom tree here since FB window not instantiated...
    var errloc = $("#" + __divZipError_ID);
    errloc.hide();

    $.fancybox.open({
        src: '#divChangeZip',
        type: 'inline',
        opts: {
            smallBtn: false,
            keyboard: true,
            modal: true,
            transitionEffect: "fade",
            transitionDuration: 200
        }
    });

    $('#' + __txtZip_ID).keyup(function (e) {
        if (e.keyCode === 13) {
            __SetZipCode();
        }
    });

    var zloc = $("#" + __fancy_div_ID + " #" + __txtZip_ID);
    var zhl = $("#" + __fancy_div_ID + " #" + __hlGoChangeZip_ID);
    zloc.val(__defaultZipText);
    zloc.unbind('click');
    zloc.unbind('keyup');
    zloc.click(function () {
        var zv = $(this).val();

        if (zv === "Zip Code" || zv === "Código Postal") {
            $(this).val("");
        }
    });

    zloc.focus();
}

function __SetZipCode() {

    // making slight adjust meant to FB traversal to handle IE7
    var z = new String();
    var zloc;
    var errloc;
    //    // note that we DO have to traverse FB dom tree here since we are in FB context
    //    var zloc = $("#" + __fancy_div_ID + " #" + __txtZip_ID);
    //    var errloc = $("#" + __fancy_div_ID + " #" + __divZipError_ID);

    var zlocs = $("input[id$='" + __txtZip_ID + "']");
    var errlocs = $("div[id$='" + __divZipError_ID + "']");

    for (var zi = 0; zi < zlocs.length; zi++) {
        var tz = zlocs[zi];
        if (tz.value !== "") {
            var zChk = parseInt(tz.value);
            if (zChk) {
                z = tz.value;
            }
            break;
        }
    }

    errlocs.hide();

    if (z !== "") {
        if (__zipCodePattern.test(z)) {
            _CreateCookie(ckInformationZipCode, z);
            _GetWeather(z);
            // refresh page?
            _FBClose();
        }
        else {
            errlocs.show();
        }
    }
    else {
        errlocs.show();
    }
}

function __CancelSetZipCode() {
    _FBClose();

    // Fixing BUG 97121 (next line and if statement).
    zc = unescape(_ReadCookie(ckInformationZipCode));
    if (!zc) {
        if (window.location.pathname.endsWith("/Personal/Products/Checking")
            || window.location.pathname.endsWith("/Personal/Products/Checking/")
        ) {
            if (window.location.pathname.indexOf("/es/") >= 0) {
                window.location.href = '/es/Personal';
            } else {
                window.location.href = '/Personal';
            }
        }

        if (window.location.pathname.endsWith("/Personal/Products/Deposit-Interest-Rates")
            || window.location.pathname.endsWith("/Personal/Products/Deposit-Interest-Rates/")
        ) {
            if (window.location.pathname.indexOf("/es/") >= 0) {
                window.location.href = '/es/Personal';
            } else {
                window.location.href = '/Personal';
            }
        }

        if (window.location.pathname.endsWith("/Personal/Products/Savings")
            || window.location.pathname.endsWith("/Personal/Products/Savings/")
        ) {
            if (window.location.pathname.indexOf("/es/") >= 0) {
                window.location.href = '/es/Personal';
            } else {
                window.location.href = '/Personal';
            }
        }

        if (window.location.pathname.endsWith("/Personal")
            || window.location.pathname.endsWith("/Personal/")
        ) {
            if (window.location.pathname.indexOf("/es/") >= 0) {
                window.location.href = '/es/';
            } else {
                window.location.href = '/';
            }
        }
    }
}

function replaceSections(newContent) {
    var content = $(newContent);
    // if not 404 -- since 404 page is sending 200 codes

    // Replacing banner section
    if (content.find('div.scbanner')) {
        var bannerSection = content.siblings('div.scbanner')[0];
        if (bannerSection !== undefined) {
            $('div.scbanner div.replace:first-of-type').replaceWith(bannerSection.innerHTML);
        }
    }

    // Showing UAO Maintenance message. 
    if (uaoMaintenance) {
        if (currentDataGroup !== undefined && currentDataGroup === "UAO") {
            var message =
                "<div class='uao-message' style='margin: 20px 0; background-color: #AED581; padding: 15px 10px 10px 10px;'>"
                + "<table><tr><td style='width: 40px; text-align: center;'>"
                + "<img alt='Exclamation icon' src='/Frontend/Images/icons/exclaimation_big_rev.png' width='31' height='31' /></td>"
                + "<td><p><strong>Scheduled Weekend Maintenance</strong></p>"
                + "<p>Some of our systems, including Online Account Opening and Online Banking, will be undergoing scheduled maintenance beginning"
                + "<strong> Saturday, February 6<sup>th</sup></strong> at approximately <strong>10:00 PM CST</strong>."
                + " During this time, you may experience brief interruptions in service. We"
                + " apologize for any inconvenience this may cause and thank you for being a valued customer!</p></td></tr></table></div>";
            $('div.uao-message').remove();
            $('div.scbanner').append(message);
        } else {
            $('div.uao-message').remove();
        }
    }

    // Replacing main content section
    if (content.find('div.sctext')) {
        var contentSection = content.siblings('div.sctext')[0];
        if (contentSection !== undefined) {
            $('div.sctext > div.replace:first-of-type').replaceWith(contentSection.innerHTML);
        }
    }

    // Replacing disclaimer section
    if (content.find('div.disclaimer')) {
        var disclaimerSection = content.siblings('div.disclaimer')[0];
        if (disclaimerSection !== undefined) {
            $('div.disclaimer > div.replace:first-of-type').replaceWith(disclaimerSection.innerHTML);
        }
    }
}

function swapContent(pageItem) {
    if (pageItem.states.length === 0) return;

    var defaultPageNameEnding = 'STD';
    var htmlFileNameExtension = '.html';
    var pageContentDirectory = '/Frontend/Docs/';
    var spanishAbbreviation = 'es';

    // check for Spanish.
    var loc = document.location.href.toString();
    var esIdx = loc.indexOf("/" + spanishAbbreviation + "/");

    // get current location
    var languageDirectory = esIdx > 0 ? spanishAbbreviation + "/" : "";
    var locDir = pageContentDirectory + languageDirectory;
    var locTbl = locDir + pageItem.fileName + "_" + defaultPageNameEnding + htmlFileNameExtension;
    var locArr = __spnrootlocation.html().split(",");

    if (locArr) {
        if (locArr.length > 0) {
            var userState = $.trim(locArr[1]);
            var stateIsSupported = false;
            for (var i = 0; i < pageItem.states.length; i++) {
                var state = pageItem.states[i];
                if (state.toLowerCase() === userState.toLowerCase()) {
                    stateIsSupported = true;
                    break;
                }
            }

            userState = stateIsSupported ? userState.replace(" ", "") : defaultPageNameEnding;

            if (pageItem.dataGroup !== undefined && pageItem.dataGroup.length !== 0) {
                userState = stateIsSupported
                    ? pageItem.dataGroup
                    : defaultPageNameEnding;

                // Setting global
                currentDataGroup = userState;
            }

            locTbl = locDir + pageItem.fileName + "_" + userState + htmlFileNameExtension;
        }
    }

    function onSuccess(data) {
        replaceSections(data);
        __activeTabs();
        __loadTabClickEvent();

        if (pageItem.fileName === 'eme') {
            updatePreviousFridayDate();
        }
    }

    $.ajax({
        url: locTbl,
        success: onSuccess,
        error: function () {
            // Texas should already be present, but if it's not load STD file
            $.ajax({
                url: locDir + pageItem.fileName + "_" + defaultPageNameEnding + htmlFileNameExtension,
                success: onSuccess
            });
        }
    });
}

// This function is a temporal fix about some wrong urls created by Composite, but only in a couple of servers.
function __fixUrls() {
    var anchors = $('a[href$=".aspx"]').toArray();

    anchors.forEach(function (a) {
        var modifiedUrl = a.href.toString();
        if (modifiedUrl.indexOf("/Home/") !== -1) {
            modifiedUrl = modifiedUrl.replace("/Home", "");
            modifiedUrl = modifiedUrl.replace(".aspx", "");
            $(a).attr("href", modifiedUrl);
        }
    });

    var options = $('option[value$=".aspx"]').toArray();

    options.forEach(function (o) {
        var modifiedValue = o.value.toString();
        if (modifiedValue.indexOf('/Home/') !== -1) {
            modifiedValue = modifiedValue.replace("/Home", "");
            modifiedValue = modifiedValue.replace(".aspx", "");
            $(o).attr("value", modifiedValue);
        }
    });
}

// New couple of functions to prevent inject malicious code.
function htmlEncode(value) {
    //create a in-memory div, set it's inner text(which jQuery automatically encodes)
    //then grab the encoded contents back out.  The div never exists on the page.
    return $('<div/>').text(value).html();
}
// Uncomment this second one if needed.
//function htmlDecode(value) {
//    return $('<div/>').html(value).text();
//}

function getPreviousFriday() {
    //var date = $('#previousFriday').text();

    var today = new Date();
    // Get the weekday from 0 to 6.
    var todayDay = today.getDay();
    var previousFriday = '';

    if (todayDay === 5) { // 5 = Friday
        previousFriday = today.toLocaleDateString();
    } else if (todayDay === 6) {  // 6 = Saturday
        today.setDate(today.getDate() - 1);
        previousFriday = today.toLocaleDateString();
    } else {
        // The next (todayDay + 2) comes from (todayDay - (-2))
        // where (-2) is the Friday position in a day line
        // Friday = -2, Saturday = -1, Sunday = 0, Monday = 1, and so on...
        var daysToSubtract = Math.abs(todayDay + 2);
        today.setDate(today.getDate() - daysToSubtract);
        previousFriday = today.toLocaleDateString();
    }

    //$('#previousFriday').text(result);
    return previousFriday;
}

function updatePreviousFridayDate() {
    // The element to replace should be surrounded by a 'span' tag
    // with the id='previousFriday'
    var elementToReplace = $('#previousFriday');

    if (elementToReplace !== undefined) {
        $('#previousFriday').text(getPreviousFriday());
    }
}

function expandableElements() {
    var expElements = document.getElementsByClassName('exp-title');

    for (var i = 0; i < expElements.length; i++) {
        expElements[i].onclick = function (e) {
            var rel = e.target.attributes.rel.nodeValue;
            var classes = e.target.className;

            if (classes.indexOf('expanded') > -1) {
                $(e.target).removeClass('expanded');
                $('#' + rel).removeClass('expanded');
            } else {
                $(e.target).addClass('expanded');
                $('#' + rel).addClass('expanded');
            }
        };
    }
}

function __activeTabs() {
    // active tabs
    $(".tab_content").hide(); //Hide all content
    $("ul.tabs li:first").addClass("active").show(); //Activate first tab            
    $(".tab_content:first").show(); //Show first tab content
}

function __loadTabClickEvent() {
    //On Click Event
    $("ul.tabs li").click(function () {

        $("ul.tabs li").removeClass("active"); //Remove any "active" class
        $(this).addClass("active"); //Add "active" class to selected tab
        $(".tab_content").hide(); //Hide all tab content

        var activeTab = $(this).find("a").attr("href"); //Find the href attribute value to identify the active tab + content
        $(activeTab).fadeIn(); //Fade in the active ID content
        return false;
    });
}

function checkLocalizableContent(pageItem) {
    if (window.location.pathname.endsWith(pageItem.url)
        || window.location.pathname.endsWith(pageItem.url.concat('/'))
    ) {
        if (window[pageItem.flag]) {
            zc = unescape(_ReadCookie(ckInformationZipCode));
            if (!zc) {
                //zc = __defaultZipCode;
                __LoadZipChange();
            } else {
                _GetWeather(zc);
            }
        } else {
            // TODO: Seba: Check how to align properly using a content tag/element.
            // Remove the change location option
            $('a#hlChangeLocation').remove();
            $('span#spnrootlocation').remove();
        }
    }
}

function initCollapsibleContent() {
    var coll = document.getElementsByClassName("collapsible");
    var i;

    for (i = 0; i < coll.length; i++) {
        coll[i].addEventListener("click", function () {
            this.classList.toggle("active");
            var content = this.nextElementSibling;
            if (content.clientHeight > 0) {
                content.style.maxHeight = 0;
            } else {
                content.style.maxHeight = content.scrollHeight + "px";
            }
        });
    }
}

function openHw(evt, hwName) {
    // Declare all variables
    var i, tabcontent, tablinks;

    // Get all elements with class="tabcontent" and hide them
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }

    // Get all elements with class="tablinks" and remove the class "active"
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }

    // Show the current tab, and add an "active" class to the button that opened the tab
    document.getElementById(hwName).style.display = "block";
    evt.currentTarget.className += " active";
}

$(document).ready(function () {
    __InitClicks();
    __InitEvents();
    __divChangeZip.hide();

    // Polyfills
    if (!String.prototype.endsWith) {
        String.prototype.endsWith = function (search, this_len) {
            if (this_len === undefined || this_len > this.length) {
                this_len = this.length;
            }
            return this.substring(this_len - search.length, this_len) === search;
        };
    }

    /* set up textbox niceys across entire app*/
    $("input:text").focus(function () { $(this).select(); });

    // activate tooltips
    $(function () {
        $(".tippy").tipTip({ defaultPosition: "right", edgeOffset: 15 });
    });

    __activeTabs();
    __loadTabClickEvent();

    // hide all expando content
    $(".expc").hide();

    // anything in the hash that we need to auto expand?
    var h = new String();
    h = document.location.hash;
    if (h) {
        h2 = h.replace("#", "");
        // we have anything that has a match rel?  just going to look for the first hit
        var expo = $("*[rel='" + htmlEncode(h2) + "']:first");
        if (expo.length > 0) {
            __Expand(expo);
        }
        else {
            // could be a tab default;
            __GoTab(h);
        }
    }

    // set up all objects that are tagged for Fancybox
    $(".fb").fancybox({
        'autoScale': false
    });

    // set up system-wide animations for ajax calls
    __divFB.ajaxStart(function () {
        $.fancybox.showActivity();
    });
    __divFB.ajaxStop(function () {
        $.fancybox.hideActivity();
    });

    // update search form action for spanish
    var sattr = __sform.attr("action");
    sattr = sattr.replace("/Home", "").replace(".aspx", "");
    __sform.attr("action", sattr);

    // missing forEach on pagesWithLocalizableContent for IE11 in some instances.
    //if (pagesWithLocalizableContent) {
    //    if (pagesWithLocalizableContent.__proto__ && !pagesWithLocalizableContent.__proto__.forEach) {
    //        pagesWithLocalizableContent.__proto__.forEach = Array.prototype.forEach;
    //    }
    //    else if (pagesWithLocalizableContent.prototype && !pagesWithLocalizableContent.prototype.forEach) {
    //        pagesWithLocalizableContent.prototype.forEach = Array.prototype.forEach;
    //    }
    //}
    // Localize content
    pagesWithLocalizableContent.forEach(function (pageItem) {
        checkLocalizableContent(pageItem);
    })

    __fixUrls();
    updatePreviousFridayDate();
    expandableElements();
    initCollapsibleContent();
});