﻿function _InitClicks() {
    $("#pauseButton").click(function () {
        // getting class to know the current state.
        var btn = $("#pauseButton");
        var btnImage = $("#pauseButton>img")[0];
        var currentState = btn.data("state");

        if (currentState === "pauseOFF") {
            fslideshow.cycle("pause");
            btn.data("state", "pauseON");
            btnImage.src = "/Frontend/Images/Hero/play-icon.png";
            btnImage.alt = "Play";
            btnImage.title = "Play";
        } else {
            fslideshow.cycle("resume");
            btn.data("state", "pauseOFF");
            btnImage.src = "/Frontend/Images/Hero/pause-icon.png";
            btnImage.alt = "Pause";
            btnImage.title = "Pause";
        }
    });

    _hlChangeLocationBanner.click(function () {
        __LoadZipChange();
    });

    _txtZip.click(function () {

        var zv = $(this).val();

        if (zv == "Zip Code" || zv == "Código Postal") {
            $(this).val("");
        }
    });
}

function _InitCycle(idx) {
    var sIndex = 0;
    //if (idx) {
    //    sIndex = idx;
    //}
    var i = getBannerIndex();
    if (i !== -1) {
        sIndex = i;
    }

    // redefine Cycle's updateActivePagerLink function 
    $.fn.cycle.updateActivePagerLink = function (pager, currSlideIndex) {
        $(pager).find('li').removeClass('active')
            .filter('li:eq(' + currSlideIndex + ')').addClass('active');
    };

    fslideshow.cycle({
        fx: 'fade',
        pause: 1,
        speed: 400,
        timeout: 8000,
        startingSlide: sIndex,
        next: hnext,
        prev: hprev,
        pager: '#htnav',
        pagerAnchorBuilder: function (idx, slide) {

            var elms = slide.getElementsByTagName("img");
            for (var i = 0, maxI = elms.length; i < maxI; ++i) {
                var iSrc = elms[i].src;
                if (iSrc) {
                    iSrc = iSrc.replace(".jpg", "circle.png");
                    return '<li class="circle"><a href="#"><span style="color:transparent;">Slider Thumnbail</span></a></li>';
                }
            }
        }
    });
}

function _InitEvents() {
    /* init search */
    _txtZip.keyup(function (e) {
        if (e.keyCode == 13) {
            _hlLocateZip.click();
        }
    });
}

function _LocationSearch() {
    // save this zip for location searching
    var lz = _txtZip.val();
    var zChk = parseInt(lz);
    if (zChk) {
        _CreateCookie(__ckBranchSearchZipCode, lz);
        // note: bsurl defined in LocateBranchForm function
        top.document.location.href = bsurl + "#ZipCode=" + lz;
    }
}

function _SetSearchZip() {
}

// New function to rotate banners each month.
function getBannerIndex() {
    switch (new Date().getMonth()) {
        case 0:
        case 4:
        case 8:
            return 0;
        case 1:
        case 5:
        case 9:
            return 0;
        case 2:
        case 6:
        case 10:
            return 0;
        case 3:
        case 7:
        case 11:
            return 0;
    }

    return -1;
}

$(document).ready(function () {
    _InitClicks();
    _InitCycle(0);
    _InitEvents();

    _txtZip.val(__defaultZipText);
});