﻿var maxWidth = 960;
var shadowOffset = 5;

var divMegaMenu = $("div.megamenu");
var megaTimeout = 1500;
var navLinks = $("div.mainnav ul li a");
var userOnLink = false;
var userOnMega = false;

function clearMM() {
    divMegaMenu.each(function () {
        $(this).hide();
    });
}

function clearMMCheck() {
    if (!userOnMega & !userOnLink) {
        clearMM();
    }
}

function mm(mi) {
    clearMM();
    if (mi) {
        var mrel = mi.attr("rel");
        var mppos = mi.parents(".mainnav").position();
        var mpos = mi.position();
        var mmx = $("#divmm" + mrel);
        if (mmx) {

            var myParentLeft = 0;
            if (mppos) {
                myParentLeft = mppos.left;
            }
            var myLeft = mpos.left;
            var myWidth = mmx.outerWidth();

            // make sure that we haven't exceeded the max container width
            if ((myParentLeft + myLeft + myWidth + shadowOffset) >= maxWidth) {
                mmx.css("right", "5px");
            }
            else {
                mmx.css("left", myParentLeft + myLeft + shadowOffset);
            }

            mmx.show();
        }
    }
}

$(document).ready(function () {

    divMegaMenu.mouseenter(function () {
        userOnLink = false;
        userOnMega = true;
    });

    divMegaMenu.mouseleave(function () {
        $(this).hide();
    });

    navLinks.mouseenter(function () {
        mm($(this));
        userOnLink = true;
        userOnMega = false;
    });

    navLinks.mouseleave(function () {
        userOnLink = false;
        // set timer if user did not mouse over menu to auto close after some number of seconds
        setTimeout("clearMMCheck()", megaTimeout);
    });

});