function ccLeftArrowClick() {
  moveLeft();
}

function ccRightArrowClick() {
  moveRight();
}

function moveRight() {
  var opinions = $('div.cc_opinion-container');

  // check if the latest is already visible so no movement needed 
  if ($(opinions[opinions.length - 1]).attr('class').indexOf('visible') !== -1) {
    // console.log('No more items on the right to show.');
    return;
  }

  // split depending visibility 
  var visibleOpinions = $('div.cc_opinion-container.visible');

  // find the item to show before change anything 
  var index;
  for (let i = 0; i < opinions.length - 1; i++) {
    const op = opinions[i];

    if ($(op).attr('class').indexOf('visible') !== -1) {
      index = i + 1;
    }
  };

  if (index > opinions.length) {
    // console.log('nothing to show on the right');
    return;
  }

  // hide the first one 
  $(visibleOpinions[0]).removeClass('visible');
  $(visibleOpinions[0]).addClass('hidden');

  // show the found item 
  $(opinions[index]).removeClass('hidden');
  $(opinions[index]).addClass('visible');
}

function moveLeft() {
  var opinions = $('div.cc_opinion-container');

  // check if the first one is already visible so no movement needed 
  if ($(opinions[0]).attr('class').indexOf('visible') !== -1) {
    //console.log('No more items on the left to show.')
    return;
  }

  // identify the div to hide 
  var visibleOpinions = $('div.cc_opinion-container.visible');

  // find the item to show before change anything 
  var index;
  for (let i = 0; i < opinions.length - 1; i++) {
    const op = opinions[i];

    if ($(op).attr('class').indexOf('visible') !== -1) {
      index = i - 1;
      break;
    }
  };

  if (index < 0) {
    // console.log('nothing to show on the left');
    return;
  }

  // hide the first one 
  $(visibleOpinions[visibleOpinions.length - 1]).removeClass('visible');
  $(visibleOpinions[visibleOpinions.length - 1]).addClass('hidden');

  // show the proper item 
  $(opinions[index]).removeClass('hidden');
  $(opinions[index]).addClass('visible');
}
